%% SEIR_simtest
%
% Plots a comparison of population classes
%
% Uses seir_sim, 2020/10/27 version
%
% User specifies values for 6 parameters:
%   R0 is the basic reproductive number
%   TL is the mean incubation time
%   TI is the mean infectious duration
%   E0 is the initial latent fraction
%   I0 is the initial infectious fraction
%   V is the initial immune fraction
%
% by Glenn Ledder
% written 2020/10/23
% revised 2020/11/08
%
% direct comments to gledder@unl.edu

%% SCENARIO DATA

R0 = 2.5;
TL = 5;
TI = 10;
E0 = 0;
I0 = 0.001;
V = 0;

%% COMMON DATA

target = 0.001;

%% INITIALIZATION

opengl hardwarebasic;
clf
hold on

%% COMPUTATION

eta = 1/TL;
gamma = 1/TI;
beta = gamma*R0;
[S,E,I,R] = seir_sim(beta,eta,gamma,E0,I0,V,target);
days = length(I)-1;
new = S(1:days)-S(2:length(S));
new = [0;new];

%% OUTPUT

times = 0:days;

plot(times,S,'LineWidth',2)
plot(times,E,'LineWidth',2)
plot(times,I,'LineWidth',2)
plot(times,R,'LineWidth',2)
xlabel('days','FontSize',18)
ylabel('population fraction','FontSize',18)
xlim([0,160])
legend('S','E','I','R','Location','East')

results = [times',S,E,I,R,new]
maxI = max(I)
finalS = S(end)
